#!/bin/bash
# Script de instalação do Plugin Flluir para macOS

echo "🚀 Instalando Plugin Flluir para Adobe Premiere Pro..."
echo ""

# Caminho base
CEP_EXTENSIONS="$HOME/Library/Application Support/Adobe/CEP/extensions"

# 1. Criar debugmode
echo "1️⃣ Criando arquivo debugmode..."
mkdir -p "$CEP_EXTENSIONS/debugmode"
echo "1" > "$CEP_EXTENSIONS/debugmode/debugmode"
echo "✅ Debug mode habilitado"
echo ""

# 1.5. Configurar PlayerDebugMode e AllowUnsignedExtensions
echo "1️⃣.5️⃣ Configurando PlayerDebugMode e AllowUnsignedExtensions..."
defaults write com.adobe.CSXS.12 PlayerDebugMode 1 2>/dev/null
defaults write com.adobe.CSXS.11 PlayerDebugMode 1 2>/dev/null
defaults write com.adobe.CSXS.10 PlayerDebugMode 1 2>/dev/null
defaults write com.adobe.CSXS.9 PlayerDebugMode 1 2>/dev/null
defaults write com.adobe.CSXS.12 AllowUnsignedExtensions -bool true 2>/dev/null
defaults write com.adobe.CSXS.11 AllowUnsignedExtensions -bool true 2>/dev/null
echo "✅ PlayerDebugMode e AllowUnsignedExtensions configurados"
echo ""

# 1.6. Criar manifest.xml para whitelist de extensões
echo "1️⃣.6️⃣ Criando whitelist de extensões..."
mkdir -p "$CEP_EXTENSIONS/CSXS"
cat > "$CEP_EXTENSIONS/CSXS/manifest.xml" << 'EOF'
<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<ExtensionList>
  <Extension Id="*" />
</ExtensionList>
EOF
echo "✅ Whitelist de extensões criada"
echo ""

# 2. Copiar plugin
echo "2️⃣ Copiando plugin..."
PLUGIN_SOURCE="$(dirname "$0")"
PLUGIN_DEST="$CEP_EXTENSIONS/Plugin Flluir"

# Remover plugin antigo se existir
if [ -d "$PLUGIN_DEST" ]; then
    echo "   Removendo instalação anterior..."
    rm -rf "$PLUGIN_DEST"
fi

# Copiar novo plugin
cp -r "$PLUGIN_SOURCE" "$PLUGIN_DEST"
echo "✅ Plugin copiado para: $PLUGIN_DEST"
echo ""

# 3. Verificar CSInterface.js
echo "3️⃣ Verificando CSInterface.js..."
if [ ! -f "$PLUGIN_DEST/CSInterface.js" ]; then
    echo "   ⚠️  CSInterface.js não encontrado!"
    echo "   📥 Baixe de: https://raw.githubusercontent.com/Adobe-CEP/CEP-Resources/master/CEP_11.x/CSInterface.js"
    echo "   💾 Salve em: $PLUGIN_DEST/CSInterface.js"
else
    echo "✅ CSInterface.js encontrado"
fi
echo ""

echo "✅ Instalação concluída!"
echo ""
echo "📋 Próximos passos:"
echo "   1. Se o CSInterface.js não estiver presente, baixe e coloque na pasta do plugin"
echo "   2. ⚠️  IMPORTANTE: Feche COMPLETAMENTE o Adobe Premiere Pro (todas as janelas)"
echo "   3. Aguarde 5-10 segundos"
echo "   4. Abra o Adobe Premiere Pro novamente"
echo "   5. Abra: Window → Extensions → Flluir: Sync (ou Janela → Extensões → Flluir: Sync)"
echo ""
echo "💡 Dica: Se o plugin não abrir, verifique os logs em:"
echo "   ~/Library/Logs/CSXS/CEP12-PPRO.log"
echo ""
